/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.block.component;

import com.google.common.base.Suppliers;
import com.technicalitiesmc.lib.block.BlockComponent;
import com.technicalitiesmc.lib.block.BlockComponentData;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class BlockItemCollection<T extends Collection<ItemStack>>
extends BlockComponent.WithData<Data<T>> {
    private static final Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});
    private static final Runnable EMPTY_RUNNABLE = () -> {};
    private final CollectionFactory<T> collectionFactory;
    private final int capacity;
    private final ItemHandlerMapper<T> exposedItemHandlerMapper;
    private final boolean shouldDropItemsOnBreak;
    private final boolean shouldOutputToComparators;
    private final boolean shouldExposeCaps;

    private BlockItemCollection(BlockComponent.Context context, CollectionFactory<T> collectionFactory, int capacity, @Nullable ItemHandlerMapper<T> exposedItemHandlerMapper, EnumSet<Flag> flags) {
        super(context, Data::new);
        this.collectionFactory = collectionFactory;
        this.capacity = capacity;
        this.exposedItemHandlerMapper = exposedItemHandlerMapper;
        this.shouldDropItemsOnBreak = flags.contains((Object)Flag.DROP_ON_BREAK);
        this.shouldOutputToComparators = flags.contains((Object)Flag.COMPARATOR_OUTPUT);
        this.shouldExposeCaps = flags.contains((Object)Flag.EXPOSE_ITEM_HANDLER) && exposedItemHandlerMapper != null;
    }

    public static <T extends Collection<ItemStack>> BlockComponent.Constructor<BlockItemCollection<T>> of(CollectionFactory<T> collectionFactory, int capacity, Flag ... flags) {
        return BlockItemCollection.of(collectionFactory, capacity, null, flags);
    }

    public static <T extends Collection<ItemStack>> BlockComponent.Constructor<BlockItemCollection<T>> of(CollectionFactory<T> collectionFactory, int capacity, @Nullable ItemHandlerMapper<T> exposedItemHandlerMapper, Flag ... flags) {
        return context -> new BlockItemCollection(context, collectionFactory, capacity, exposedItemHandlerMapper, flags.length != 0 ? EnumSet.copyOf(Arrays.asList(flags)) : EnumSet.noneOf(Flag.class));
    }

    public int capacity() {
        return this.capacity;
    }

    @Nullable
    public T at(BlockGetter level, BlockPos pos, BlockState state) {
        Data data = (Data)this.getData(level, pos, state);
        return data == null ? null : (T)data.collection;
    }

    @Nullable
    public IItemHandler itemHandlerAt(BlockGetter level, BlockPos pos, BlockState state) {
        Data data = (Data)this.getData(level, pos, state);
        return data == null ? null : data.itemHandler.get();
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (!moving && this.shouldDropItemsOnBreak && !state.m_60713_(newState.m_60734_())) {
            Data data = (Data)this.getData((BlockGetter)level, pos, state);
            if (data != null) {
                NonNullList list = NonNullList.m_122779_();
                list.addAll(data.collection);
                Containers.m_19010_((Level)level, (BlockPos)pos, (NonNullList)list);
            }
            level.m_46717_(pos, (Block)this.getBlock());
        }
    }

    @Override
    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        Data data;
        if (this.shouldOutputToComparators && (data = (Data)this.getData((BlockGetter)level, pos, state)) != null) {
            return data.collection.size() * 15 / this.capacity;
        }
        return 0;
    }

    @FunctionalInterface
    public static interface CollectionFactory<T extends Collection<ItemStack>> {
        public T createCollection();
    }

    @FunctionalInterface
    public static interface ItemHandlerMapper<T extends Collection<ItemStack>> {
        public IItemHandler asItemHandler(T var1, int var2, Runnable var3);
    }

    public static enum Flag {
        COMPARATOR_OUTPUT,
        DROP_ON_BREAK,
        EXPOSE_ITEM_HANDLER;

    }

    public static class Data<T extends Collection<ItemStack>>
    extends BlockComponentData<BlockItemCollection<T>> {
        private final T collection;
        private final Supplier<IItemHandler> itemHandler;
        private final LazyOptional<IItemHandler> lazyItemHandler;

        private Data(BlockComponentData.Context context) {
            super(context);
            BlockItemCollection component = (BlockItemCollection)this.getComponent();
            this.collection = component.collectionFactory.createCollection();
            this.itemHandler = Suppliers.memoize(() -> component.exposedItemHandlerMapper.asItemHandler(this.collection, component.capacity, this::onCollectionChanged));
            this.lazyItemHandler = component.shouldExposeCaps ? LazyOptional.of(this.itemHandler::get) : LazyOptional.empty();
        }

        private void onCollectionChanged() {
            this.markUnsaved();
            if (((BlockItemCollection)this.getComponent()).shouldOutputToComparators) {
                this.updateComparators();
            }
        }

        @Override
        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == ITEM_HANDLER_CAPABILITY) {
                return this.lazyItemHandler.cast();
            }
            return super.getCapability(cap, side);
        }

        @Override
        public CompoundTag save(CompoundTag tag) {
            ListTag tagList = new ListTag();
            for (ItemStack stack : this.collection) {
                tagList.add((Object)stack.m_41739_(new CompoundTag()));
            }
            tag.m_128365_("inventory", (Tag)tagList);
            return tag;
        }

        @Override
        public void load(CompoundTag tag) {
            ListTag tagList = tag.m_128437_("inventory", 10);
            this.collection.clear();
            for (Tag itemTag : tagList) {
                this.collection.add((ItemStack)ItemStack.m_41712_((CompoundTag)((CompoundTag)itemTag)));
            }
        }
    }
}

